/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.entity.CeramicDishBlockEntity;
import net.hecco.bountifulfares.block.interfaces.CeramicDishBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.item.custom.AirTimeIncreasingItem;
import net.hecco.bountifulfares.util.BFItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CeramicDishBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock,
CeramicDishBlockInterface {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public CeramicDishBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        if (CeramicDishBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.m_7397_(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)BFBlocks.CERAMIC_DISH);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CeramicDishBlockEntity) {
            CeramicDishBlockEntity blockEntity2 = (CeramicDishBlockEntity)blockEntity;
            ItemStack itemStack = player.m_21120_(hand);
            ItemStack stack = blockEntity2.m_8020_(0);
            if (itemStack.m_150930_(BFItems.ARTISAN_BRUSH) && itemStack.m_41737_("display") != null) {
                int brushColor = itemStack.m_41737_("display").m_128451_("color");
                world.m_7471_(pos, false);
                world.m_46597_(pos, this.m_152465_(state));
                blockEntity2.insertItem(stack);
                world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() / 3.0f);
                BlockEntity blockEntity3 = world.m_7702_(pos);
                if (blockEntity3 instanceof CeramicDishBlockEntity) {
                    CeramicDishBlockEntity ceramicDishBlockEntity = (CeramicDishBlockEntity)blockEntity3;
                    if (ceramicDishBlockEntity.color != brushColor) {
                        ceramicDishBlockEntity.color = brushColor;
                        ceramicDishBlockEntity.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                if (!item.m_41619_() && blockEntity2.canInsertItem()) {
                    blockEntity2.insertItem(item);
                    if (!player.m_7500_()) {
                        item.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!stack.m_41619_()) {
                    boolean shouldIgnore;
                    if (player.m_6144_() && item.m_41619_()) {
                        player.m_21008_(hand, stack);
                        blockEntity2.removeItem();
                        blockEntity2.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                    if (stack.m_204117_(BFItemTags.EATABLE_ON_DISH) && stack.m_41614_() && player.m_36391_(shouldIgnore = stack.m_41720_().m_41473_().m_38747_())) {
                        int i;
                        int hunger = Objects.requireNonNull(stack.m_41720_().m_41473_()).m_38744_();
                        float sat = stack.m_41720_().m_41473_().m_38745_();
                        List effects = stack.m_41720_().m_41473_().m_38749_();
                        player.m_36324_().m_38707_(hunger, sat);
                        world.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.BLOCKS, 0.5f, 0.8f + world.f_46441_.m_188501_());
                        world.m_5594_(null, pos, SoundEvents.f_12321_, SoundSource.BLOCKS, 0.3f, 1.0f);
                        if (stack.m_41720_() instanceof AirTimeIncreasingItem) {
                            int maxAir;
                            int air = player.m_20146_();
                            if (air < (maxAir = player.m_6062_()) - AirTimeIncreasingItem.airTickIncrease) {
                                player.m_20301_(air + AirTimeIncreasingItem.airTickIncrease);
                            } else {
                                player.m_20301_(maxAir);
                            }
                        }
                        if (stack.m_150930_(Items.f_42730_)) {
                            this.chorusTeleport(world, (LivingEntity)player);
                        }
                        for (i = 0; i < effects.size(); ++i) {
                            MobEffectInstance effect = (MobEffectInstance)((Pair)effects.get(i)).getFirst();
                            int length = effect.m_19557_();
                            int amplifier = effect.m_19564_();
                            MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), length, amplifier);
                            player.m_7292_(newEffect);
                        }
                        for (i = 0; i < 4 + world.f_46441_.m_216332_(0, 4); ++i) {
                            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)pos.m_123341_() + world.f_46441_.m_188583_() / 12.0 + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + world.f_46441_.m_188583_() / 12.0 + 0.5, ((double)world.f_46441_.m_188501_() - 0.5) / 8.0, ((double)world.f_46441_.m_188501_() - 0.5) / 8.0, ((double)world.f_46441_.m_188501_() - 0.5) / 8.0);
                        }
                        blockEntity2.removeItem();
                        blockEntity2.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CeramicDishBlockEntity) {
                CeramicDishBlockEntity entity = (CeramicDishBlockEntity)blockEntity;
                CeramicDishBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)entity.m_8020_(0));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        return CeramicDishBlock.m_49936_((BlockGetter)world, (BlockPos)blockPos) || CeramicDishBlock.m_49863_((LevelReader)world, (BlockPos)blockPos, (Direction)Direction.UP);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CeramicDishBlockEntity(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public void chorusTeleport(Level world, LivingEntity user) {
        if (!world.f_46443_) {
            double d = user.m_20185_();
            double e = user.m_20186_();
            double f = user.m_20189_();
            for (int i = 0; i < 16; ++i) {
                double g = user.m_20185_() + (user.m_217043_().m_188500_() - 0.5) * 16.0;
                double h = Mth.m_14008_((double)(user.m_20186_() + (double)(user.m_217043_().m_188503_(16) - 8)), (double)world.m_141937_(), (double)(world.m_141937_() + ((ServerLevel)world).m_143344_() - 1));
                double j = user.m_20189_() + (user.m_217043_().m_188500_() - 0.5) * 16.0;
                if (user.m_20159_()) {
                    user.m_8127_();
                }
                Vec3 vec3d = user.m_20182_();
                if (!user.m_20984_(g, h, j, true)) continue;
                world.m_214171_(GameEvent.f_238175_, vec3d, GameEvent.Context.m_223717_((Entity)user));
                SoundEvent soundEvent = user instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                world.m_6263_((Player)null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                user.m_5496_(soundEvent, 1.0f, 1.0f);
                break;
            }
        }
    }
}

